/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiRegistryAdapter;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.config.EffectLocation;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.FluidUnit;
import dev.emi.emi.handler.CookingRecipeHandler;
import dev.emi.emi.handler.CraftingRecipeHandler;
import dev.emi.emi.handler.InventoryRecipeHandler;
import dev.emi.emi.handler.StonecuttingRecipeHandler;
import dev.emi.emi.mixin.accessor.AxeItemAccessor;
import dev.emi.emi.mixin.accessor.HandledScreenAccessor;
import dev.emi.emi.mixin.accessor.HoeItemAccessor;
import dev.emi.emi.mixin.accessor.ShovelItemAccessor;
import dev.emi.emi.mixin.accessor.SmithingTransformRecipeAccessor;
import dev.emi.emi.mixin.accessor.SmithingTrimRecipeAccessor;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import dev.emi.emi.recipe.EmiCompostingRecipe;
import dev.emi.emi.recipe.EmiCookingRecipe;
import dev.emi.emi.recipe.EmiFuelRecipe;
import dev.emi.emi.recipe.EmiGrindstoneRecipe;
import dev.emi.emi.recipe.EmiShapedRecipe;
import dev.emi.emi.recipe.EmiShapelessRecipe;
import dev.emi.emi.recipe.EmiSmithingRecipe;
import dev.emi.emi.recipe.EmiStonecuttingRecipe;
import dev.emi.emi.recipe.EmiTagRecipe;
import dev.emi.emi.recipe.special.EmiAnvilEnchantRecipe;
import dev.emi.emi.recipe.special.EmiAnvilRepairItemRecipe;
import dev.emi.emi.recipe.special.EmiArmorDyeRecipe;
import dev.emi.emi.recipe.special.EmiBannerDuplicateRecipe;
import dev.emi.emi.recipe.special.EmiBannerShieldRecipe;
import dev.emi.emi.recipe.special.EmiBookCloningRecipe;
import dev.emi.emi.recipe.special.EmiFireworkRocketRecipe;
import dev.emi.emi.recipe.special.EmiFireworkStarFadeRecipe;
import dev.emi.emi.recipe.special.EmiFireworkStarRecipe;
import dev.emi.emi.recipe.special.EmiGrindstoneDisenchantingBookRecipe;
import dev.emi.emi.recipe.special.EmiGrindstoneDisenchantingRecipe;
import dev.emi.emi.recipe.special.EmiMapCloningRecipe;
import dev.emi.emi.recipe.special.EmiRepairItemRecipe;
import dev.emi.emi.recipe.special.EmiSmithingTrimRecipe;
import dev.emi.emi.recipe.special.EmiSuspiciousStewRecipe;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.stack.serializer.FluidEmiStackSerializer;
import dev.emi.emi.stack.serializer.ItemEmiStackSerializer;
import dev.emi.emi.stack.serializer.ListEmiIngredientSerializer;
import dev.emi.emi.stack.serializer.TagEmiIngredientSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.ArmorDyeRecipe;
import net.minecraft.world.item.crafting.BannerDuplicateRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.BookCloningRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.FireworkRocketRecipe;
import net.minecraft.world.item.crafting.FireworkStarFadeRecipe;
import net.minecraft.world.item.crafting.FireworkStarRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.MapCloningRecipe;
import net.minecraft.world.item.crafting.MapExtendingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.RepairItemRecipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.ShieldDecorationRecipe;
import net.minecraft.world.item.crafting.ShulkerBoxColoring;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.SuspiciousStewRecipe;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@EmiEntrypoint
public class VanillaPlugin
implements EmiPlugin {
    public static EmiRecipeCategory TAG = new EmiRecipeCategory(EmiPort.id("emi:tag"), EmiStack.of((ItemLike)Items.NAME_TAG), VanillaPlugin.simplifiedRenderer(240, 208), EmiRecipeSorting.none());
    public static EmiRecipeCategory INGREDIENT = new EmiRecipeCategory(EmiPort.id("emi:ingredient"), EmiStack.of((ItemLike)Items.COMPASS), VanillaPlugin.simplifiedRenderer(240, 208));
    public static EmiRecipeCategory RESOLUTION = new EmiRecipeCategory(EmiPort.id("emi:resolution"), EmiStack.of((ItemLike)Items.COMPASS), VanillaPlugin.simplifiedRenderer(240, 208));

    @Override
    public void initialize(EmiInitRegistry registry) {
        registry.addIngredientSerializer(ItemEmiStack.class, new ItemEmiStackSerializer());
        registry.addIngredientSerializer(FluidEmiStack.class, new FluidEmiStackSerializer());
        registry.addIngredientSerializer(TagEmiIngredient.class, new TagEmiIngredientSerializer());
        registry.addIngredientSerializer(ListEmiIngredient.class, new ListEmiIngredientSerializer());
        registry.addRegistryAdapter(EmiRegistryAdapter.simple(Item.class, EmiPort.getItemRegistry(), EmiStack::of));
        registry.addRegistryAdapter(EmiRegistryAdapter.simple(Fluid.class, EmiPort.getFluidRegistry(), EmiStack::of));
    }

    @Override
    public void register(EmiRegistry registry) {
        registry.addCategory(VanillaEmiRecipeCategories.CRAFTING);
        registry.addCategory(VanillaEmiRecipeCategories.SMELTING);
        registry.addCategory(VanillaEmiRecipeCategories.BLASTING);
        registry.addCategory(VanillaEmiRecipeCategories.SMOKING);
        registry.addCategory(VanillaEmiRecipeCategories.CAMPFIRE_COOKING);
        registry.addCategory(VanillaEmiRecipeCategories.STONECUTTING);
        registry.addCategory(VanillaEmiRecipeCategories.SMITHING);
        registry.addCategory(VanillaEmiRecipeCategories.ANVIL_REPAIRING);
        registry.addCategory(VanillaEmiRecipeCategories.GRINDING);
        registry.addCategory(VanillaEmiRecipeCategories.BREWING);
        registry.addCategory(VanillaEmiRecipeCategories.WORLD_INTERACTION);
        registry.addCategory(VanillaEmiRecipeCategories.FUEL);
        registry.addCategory(VanillaEmiRecipeCategories.COMPOSTING);
        registry.addCategory(VanillaEmiRecipeCategories.INFO);
        registry.addCategory(TAG);
        registry.addCategory(INGREDIENT);
        registry.addCategory(RESOLUTION);
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, EmiStack.of((ItemLike)Items.CRAFTING_TABLE));
        registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiStack.of((ItemLike)Items.FURNACE));
        registry.addWorkstation(VanillaEmiRecipeCategories.BLASTING, EmiStack.of((ItemLike)Items.BLAST_FURNACE));
        registry.addWorkstation(VanillaEmiRecipeCategories.SMOKING, EmiStack.of((ItemLike)Items.SMOKER));
        registry.addWorkstation(VanillaEmiRecipeCategories.CAMPFIRE_COOKING, EmiStack.of((ItemLike)Items.CAMPFIRE));
        registry.addWorkstation(VanillaEmiRecipeCategories.CAMPFIRE_COOKING, EmiStack.of((ItemLike)Items.SOUL_CAMPFIRE));
        registry.addWorkstation(VanillaEmiRecipeCategories.STONECUTTING, EmiStack.of((ItemLike)Items.STONECUTTER));
        registry.addWorkstation(VanillaEmiRecipeCategories.SMITHING, EmiStack.of((ItemLike)Items.SMITHING_TABLE));
        registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of((ItemLike)Items.ANVIL));
        registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of((ItemLike)Items.CHIPPED_ANVIL));
        registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of((ItemLike)Items.DAMAGED_ANVIL));
        registry.addWorkstation(VanillaEmiRecipeCategories.BREWING, EmiStack.of((ItemLike)Items.BREWING_STAND));
        registry.addWorkstation(VanillaEmiRecipeCategories.GRINDING, EmiStack.of((ItemLike)Items.GRINDSTONE));
        registry.addWorkstation(VanillaEmiRecipeCategories.COMPOSTING, EmiStack.of((ItemLike)Items.COMPOSTER));
        registry.addRecipeHandler(null, new InventoryRecipeHandler());
        registry.addRecipeHandler(MenuType.CRAFTING, new CraftingRecipeHandler());
        registry.addRecipeHandler(MenuType.FURNACE, new CookingRecipeHandler(VanillaEmiRecipeCategories.SMELTING));
        registry.addRecipeHandler(MenuType.BLAST_FURNACE, new CookingRecipeHandler(VanillaEmiRecipeCategories.BLASTING));
        registry.addRecipeHandler(MenuType.SMOKER, new CookingRecipeHandler(VanillaEmiRecipeCategories.SMOKING));
        registry.addRecipeHandler(MenuType.STONECUTTER, new StonecuttingRecipeHandler());
        registry.addExclusionArea(CreativeModeInventoryScreen.class, (screen, consumer) -> {
            int left = ((HandledScreenAccessor)screen).getX();
            int top = ((HandledScreenAccessor)screen).getY();
            int width = ((HandledScreenAccessor)screen).getBackgroundWidth();
            int bottom = top + ((HandledScreenAccessor)screen).getBackgroundHeight();
            consumer.accept(new Bounds(left, top - 28, width, 28));
            consumer.accept(new Bounds(left, bottom, width, 28));
        });
        registry.addGenericExclusionArea((screen, consumer) -> {
            if (EmiConfig.effectLocation != EffectLocation.HIDDEN && screen instanceof EffectRenderingInventoryScreen) {
                EffectRenderingInventoryScreen inv = (EffectRenderingInventoryScreen)screen;
                Minecraft client = Minecraft.getInstance();
                Collection collection = client.player.getActiveEffects();
                if (!collection.isEmpty()) {
                    int right;
                    int rightWidth;
                    int k = 33;
                    if (collection.size() > 5) {
                        k = 132 / (collection.size() - 1);
                    }
                    if ((rightWidth = inv.width - (right = ((HandledScreenAccessor)inv).getX() + ((HandledScreenAccessor)inv).getBackgroundWidth() + 2)) >= 32) {
                        int left;
                        int width;
                        int top = ((HandledScreenAccessor)inv).getY();
                        int height = (collection.size() - 1) * k + 32;
                        if (EmiConfig.effectLocation == EffectLocation.TOP) {
                            int size = collection.size();
                            top = ((HandledScreenAccessor)inv).getY() - 34;
                            if (screen instanceof CreativeModeInventoryScreen) {
                                top -= 28;
                                if (EmiAgnos.isForge()) {
                                    top -= 22;
                                }
                            }
                            int xOff = 34;
                            if (size == 1) {
                                xOff = 122;
                            } else if (size > 5) {
                                xOff = (((HandledScreenAccessor)inv).getBackgroundWidth() - 32) / (size - 1);
                            }
                            width = Math.max(122, (size - 1) * xOff + 32);
                            left = ((HandledScreenAccessor)inv).getX() + (((HandledScreenAccessor)inv).getBackgroundWidth() - width) / 2;
                            height = 32;
                        } else {
                            left = switch (EmiConfig.effectLocation) {
                                case EffectLocation.LEFT_COMPRESSED -> ((HandledScreenAccessor)inv).getX() - 2 - 32;
                                case EffectLocation.LEFT -> ((HandledScreenAccessor)inv).getX() - 2 - 120;
                                default -> right;
                            };
                            width = switch (EmiConfig.effectLocation) {
                                case EffectLocation.LEFT, EffectLocation.RIGHT -> 120;
                                case EffectLocation.LEFT_COMPRESSED, EffectLocation.RIGHT_COMPRESSED -> 32;
                                default -> 32;
                            };
                        }
                        consumer.accept(new Bounds(left, top, width, height));
                    }
                }
            }
        });
        Comparison potionComparison = Comparison.compareData(stack -> (PotionContents)stack.get(DataComponents.POTION_CONTENTS));
        registry.setDefaultComparison((Object)Items.POTION, potionComparison);
        registry.setDefaultComparison((Object)Items.SPLASH_POTION, potionComparison);
        registry.setDefaultComparison((Object)Items.LINGERING_POTION, potionComparison);
        registry.setDefaultComparison((Object)Items.TIPPED_ARROW, potionComparison);
        registry.setDefaultComparison((Object)Items.ENCHANTED_BOOK, EmiPort.compareStrict());
        Set hiddenItems = Stream.concat(EmiUtil.values(TagKey.create((ResourceKey)EmiPort.getItemRegistry().key(), (ResourceLocation)EmiTags.HIDDEN_FROM_RECIPE_VIEWERS)).map(Holder::value), EmiPort.getDisabledItems()).collect(Collectors.toSet());
        List dyeableItems = EmiUtil.values(ItemTags.DYEABLE).map(Holder::value).collect(Collectors.toList());
        for (CraftingRecipe craftingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.CRAFTING)) {
            ResourceLocation id = EmiPort.getId(craftingRecipe);
            if (craftingRecipe instanceof MapExtendingRecipe) {
                MapExtendingRecipe map = (MapExtendingRecipe)craftingRecipe;
                EmiStack paper = EmiStack.of((ItemLike)Items.PAPER);
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(List.of(paper, paper, paper, paper, EmiStack.of((ItemLike)Items.FILLED_MAP), paper, paper, paper, paper), EmiStack.of((ItemLike)Items.FILLED_MAP), id, false), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof ShapedRecipe) {
                ShapedRecipe shaped = (ShapedRecipe)craftingRecipe;
                if (craftingRecipe.canCraftInDimensions(3, 3)) {
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiShapedRecipe(shaped), craftingRecipe);
                    continue;
                }
            }
            if (craftingRecipe instanceof ShapelessRecipe) {
                ShapelessRecipe shapeless = (ShapelessRecipe)craftingRecipe;
                if (craftingRecipe.canCraftInDimensions(3, 3)) {
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiShapelessRecipe(shapeless), craftingRecipe);
                    continue;
                }
            }
            if (craftingRecipe instanceof ArmorDyeRecipe) {
                ArmorDyeRecipe dye = (ArmorDyeRecipe)craftingRecipe;
                for (Item i : dyeableItems) {
                    if (hiddenItems.contains(i)) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiArmorDyeRecipe(i, VanillaPlugin.synthetic("crafting/dying", EmiUtil.subId(i))), craftingRecipe);
                }
                continue;
            }
            if (craftingRecipe instanceof SuspiciousStewRecipe) {
                SuspiciousStewRecipe stew = (SuspiciousStewRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiSuspiciousStewRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof ShulkerBoxColoring) {
                ShulkerBoxColoring shulker = (ShulkerBoxColoring)craftingRecipe;
                for (DyeColor dye : DyeColor.values()) {
                    DyeItem dyeItem = DyeItem.byColor((DyeColor)dye);
                    ResourceLocation sid = VanillaPlugin.synthetic("crafting/shulker_box_dying", EmiUtil.subId((Item)dyeItem));
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(List.of(EmiStack.of((ItemLike)Items.SHULKER_BOX), EmiStack.of((ItemLike)dyeItem)), EmiStack.of(ShulkerBoxBlock.getColoredItemStack((DyeColor)dye)), sid), craftingRecipe);
                }
                continue;
            }
            if (craftingRecipe instanceof ShieldDecorationRecipe) {
                ShieldDecorationRecipe shield = (ShieldDecorationRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiBannerShieldRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof BookCloningRecipe) {
                BookCloningRecipe book = (BookCloningRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiBookCloningRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof TippedArrowRecipe) {
                TippedArrowRecipe tipped = (TippedArrowRecipe)craftingRecipe;
                EmiPort.getPotionRegistry().holders().forEach(entry -> {
                    EmiStack arrow = EmiStack.of((ItemLike)Items.ARROW);
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(List.of(arrow, arrow, arrow, arrow, EmiStack.of(EmiPort.setPotion(new ItemStack((ItemLike)Items.LINGERING_POTION), (Potion)entry.value())), arrow, arrow, arrow, arrow), EmiStack.of(EmiPort.setPotion(new ItemStack((ItemLike)Items.TIPPED_ARROW, 8), (Potion)entry.value())), VanillaPlugin.synthetic("crafting/tipped_arrow", EmiUtil.subId(EmiPort.getPotionRegistry().getKey((Object)((Potion)entry.value())))), false), recipe);
                });
                continue;
            }
            if (craftingRecipe instanceof FireworkStarRecipe) {
                FireworkStarRecipe star = (FireworkStarRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkStarRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof FireworkStarFadeRecipe) {
                FireworkStarFadeRecipe star = (FireworkStarFadeRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkStarFadeRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof FireworkRocketRecipe) {
                FireworkRocketRecipe rocket = (FireworkRocketRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkRocketRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof BannerDuplicateRecipe) {
                BannerDuplicateRecipe banner = (BannerDuplicateRecipe)craftingRecipe;
                for (Item i : EmiBannerDuplicateRecipe.BANNERS) {
                    if (hiddenItems.contains(i)) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiBannerDuplicateRecipe(i, VanillaPlugin.synthetic("crafting/banner_copying", EmiUtil.subId(i))), craftingRecipe);
                }
                continue;
            }
            if (craftingRecipe instanceof RepairItemRecipe) {
                RepairItemRecipe tool = (RepairItemRecipe)craftingRecipe;
                for (Item i : EmiRepairItemRecipe.TOOLS) {
                    if (hiddenItems.contains(i)) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiRepairItemRecipe(i, VanillaPlugin.synthetic("crafting/repairing", EmiUtil.subId(i))), craftingRecipe);
                }
                continue;
            }
            if (craftingRecipe instanceof MapCloningRecipe) {
                MapCloningRecipe map = (MapCloningRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiMapCloningRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof CustomRecipe) continue;
            try {
                ArrayList input;
                boolean shapeless;
                if (craftingRecipe.getIngredients().isEmpty() || EmiPort.getOutput(craftingRecipe).isEmpty() || !craftingRecipe.canCraftInDimensions(3, 3)) continue;
                boolean bl = shapeless = craftingRecipe.canCraftInDimensions(1, craftingRecipe.getIngredients().size()) && craftingRecipe.canCraftInDimensions(craftingRecipe.getIngredients().size(), 1);
                if (shapeless) {
                    input = craftingRecipe.getIngredients().stream().map(EmiIngredient::of).toList();
                } else {
                    int width = craftingRecipe.canCraftInDimensions(2, 3) ? (craftingRecipe.canCraftInDimensions(1, 3) ? 1 : 2) : 3;
                    input = Lists.newArrayList();
                    for (int i = 0; i < craftingRecipe.getIngredients().size(); ++i) {
                        input.add(EmiIngredient.of((Ingredient)craftingRecipe.getIngredients().get(i)));
                        if ((i + 1) % width != 0) continue;
                        for (int j = width; j < 3; ++j) {
                            input.add(EmiStack.EMPTY);
                        }
                    }
                }
                EmiShapedRecipe.setRemainders(input, craftingRecipe);
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(input, EmiStack.of(EmiPort.getOutput(recipe)), id, shapeless));
            }
            catch (Exception e) {
                EmiReloadLog.warn("Exception when parsing vanilla crafting recipe " + String.valueOf(id), e);
            }
        }
        for (SmeltingRecipe smeltingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.SMELTING)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((AbstractCookingRecipe)smeltingRecipe, VanillaEmiRecipeCategories.SMELTING, 1, false), smeltingRecipe);
        }
        for (BlastingRecipe blastingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.BLASTING)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((AbstractCookingRecipe)blastingRecipe, VanillaEmiRecipeCategories.BLASTING, 2, false), blastingRecipe);
        }
        for (SmokingRecipe smokingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.SMOKING)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((AbstractCookingRecipe)smokingRecipe, VanillaEmiRecipeCategories.SMOKING, 2, false), smokingRecipe);
        }
        for (CampfireCookingRecipe campfireCookingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.CAMPFIRE_COOKING)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((AbstractCookingRecipe)campfireCookingRecipe, VanillaEmiRecipeCategories.CAMPFIRE_COOKING, 1, true), campfireCookingRecipe);
        }
        for (SmithingRecipe smithingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.SMITHING)) {
            Minecraft client = Minecraft.getInstance();
            if (smithingRecipe instanceof SmithingTransformRecipeAccessor) {
                SmithingTransformRecipeAccessor stra = (SmithingTransformRecipeAccessor)smithingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiSmithingRecipe(EmiIngredient.of(stra.getTemplate()), EmiIngredient.of(stra.getBase()), EmiIngredient.of(stra.getAddition()), EmiStack.of(EmiPort.getOutput(smithingRecipe)), EmiPort.getId(smithingRecipe)), smithingRecipe);
                continue;
            }
            if (!(smithingRecipe instanceof SmithingTrimRecipeAccessor)) continue;
            SmithingTrimRecipeAccessor stra = (SmithingTrimRecipeAccessor)smithingRecipe;
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiSmithingTrimRecipe(EmiIngredient.of(stra.getTemplate()), EmiIngredient.of(stra.getBase()), EmiIngredient.of(stra.getAddition()), EmiStack.of(EmiPort.getOutput(smithingRecipe)), smithingRecipe), smithingRecipe);
        }
        for (StonecutterRecipe stonecutterRecipe : VanillaPlugin.getRecipes(registry, RecipeType.STONECUTTING)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiStonecuttingRecipe(stonecutterRecipe), stonecutterRecipe);
        }
        VanillaPlugin.safely("repair", () -> VanillaPlugin.addRepair(registry, hiddenItems));
        VanillaPlugin.safely("brewing", () -> EmiAgnos.addBrewingRecipes(registry));
        VanillaPlugin.safely("world interaction", () -> VanillaPlugin.addWorldInteraction(registry, hiddenItems, dyeableItems));
        VanillaPlugin.safely("fuel", () -> VanillaPlugin.addFuel(registry, hiddenItems));
        VanillaPlugin.safely("composting", () -> VanillaPlugin.addComposting(registry, hiddenItems));
        for (TagKey tagKey : EmiTags.TAGS) {
            if (new TagEmiIngredient(tagKey, 1L).getEmiStacks().size() <= 1) continue;
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiTagRecipe(key));
        }
    }

    private static void addRepair(EmiRegistry registry, Set<Item> hiddenItems) {
        ArrayList targetedEnchantments = Lists.newArrayList();
        ArrayList universalEnchantments = Lists.newArrayList();
        for (Enchantment enchantment : EmiPort.getEnchantmentRegistry().stream().toList()) {
            try {
                if (enchantment.canEnchant(ItemStack.EMPTY)) {
                    universalEnchantments.add(enchantment);
                    continue;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            targetedEnchantments.add(enchantment);
        }
        for (Item i : EmiPort.getItemRegistry()) {
            TallFlowerBlock tf;
            BlockItem bi;
            Block consumer;
            if (hiddenItems.contains(i)) continue;
            try {
                if ((Integer)i.components().getOrDefault(DataComponents.MAX_DAMAGE, (Object)0) > 0) {
                    TieredItem ti;
                    ArmorItem ai;
                    if (i instanceof ArmorItem && (ai = (ArmorItem)i).getMaterial() != null && ((ArmorMaterial)ai.getMaterial().value()).repairIngredient().get() != null && !((Ingredient)((ArmorMaterial)ai.getMaterial().value()).repairIngredient().get()).isEmpty()) {
                        id = VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(i) + "/" + EmiUtil.subId(((Ingredient)((ArmorMaterial)ai.getMaterial().value()).repairIngredient().get()).getItems()[0].getItem()));
                        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((ItemLike)i), EmiIngredient.of((Ingredient)((ArmorMaterial)ai.getMaterial().value()).repairIngredient().get()), id));
                    } else if (i instanceof TieredItem && (ti = (TieredItem)i).getTier().getRepairIngredient() != null && !ti.getTier().getRepairIngredient().isEmpty()) {
                        id = VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(i) + "/" + EmiUtil.subId(ti.getTier().getRepairIngredient().getItems()[0].getItem()));
                        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((ItemLike)i), EmiIngredient.of(ti.getTier().getRepairIngredient()), id));
                    }
                }
                if ((Integer)i.components().getOrDefault(DataComponents.MAX_DAMAGE, (Object)0) > 0) {
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRepairItemRecipe(i, VanillaPlugin.synthetic("anvil/repairing/tool", EmiUtil.subId(i))));
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiGrindstoneRecipe(i, VanillaPlugin.synthetic("grindstone/repairing", EmiUtil.subId(i))));
                }
            }
            catch (Throwable t) {
                EmiLog.error("Exception thrown registering repair recipes", t);
            }
            try {
                ItemStack defaultStack = i.getDefaultInstance();
                int acceptableEnchantments = 0;
                consumer = e -> {
                    int max = e.getMaxLevel();
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilEnchantRecipe(i, (Enchantment)e, max, VanillaPlugin.synthetic("anvil/enchanting", EmiUtil.subId(i) + "/" + EmiUtil.subId(EmiPort.getEnchantmentRegistry().getKey(e)) + "/" + max)));
                };
                for (Enchantment e2 : targetedEnchantments) {
                    if (!e2.canEnchant(defaultStack)) continue;
                    consumer.accept(e2);
                    ++acceptableEnchantments;
                }
                if (acceptableEnchantments > 0) {
                    for (Enchantment e2 : universalEnchantments) {
                        if (!e2.canEnchant(defaultStack)) continue;
                        consumer.accept(e2);
                        ++acceptableEnchantments;
                    }
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiGrindstoneDisenchantingRecipe(i, VanillaPlugin.synthetic("grindstone/disenchanting/tool", EmiUtil.subId(i))));
                }
            }
            catch (Throwable t) {
                EmiReloadLog.warn("Exception thrown registering enchantment recipes", t);
            }
            if (!(i instanceof BlockItem) || !((consumer = (bi = (BlockItem)i).getBlock()) instanceof TallFlowerBlock) || !EmiPort.canTallFlowerDuplicate(tf = (TallFlowerBlock)consumer)) continue;
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)bi).setRemainder(EmiStack.of((ItemLike)bi)), EmiStack.of((ItemLike)Items.BONE_MEAL), EmiStack.of((ItemLike)i), VanillaPlugin.synthetic("world/flower_duping", EmiUtil.subId(i)), false));
        }
        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((ItemLike)Items.ELYTRA), EmiStack.of((ItemLike)Items.PHANTOM_MEMBRANE), VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(Items.ELYTRA) + "/" + EmiUtil.subId(Items.PHANTOM_MEMBRANE))));
        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((ItemLike)Items.SHIELD), EmiIngredient.of(ItemTags.PLANKS), VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(Items.SHIELD) + "/" + EmiUtil.subId(Items.OAK_PLANKS))));
        for (Enchantment e3 : EmiPort.getEnchantmentRegistry().stream().toList()) {
            if (EmiPort.getEnchantmentRegistry().wrapAsHolder((Object)e3).is(EnchantmentTags.CURSE)) continue;
            int max = Math.min(10, e3.getMaxLevel());
            int min = e3.getMinLevel();
            while (min <= max) {
                int level = min++;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiGrindstoneDisenchantingBookRecipe(e3, level, VanillaPlugin.synthetic("grindstone/disenchanting/book", EmiUtil.subId(EmiPort.getEnchantmentRegistry().getKey((Object)e3)) + "/" + level)));
            }
        }
    }

    private static void addWorldInteraction(EmiRegistry registry, Set<Item> hiddenItems, List<Item> dyeableItems) {
        ResourceLocation id;
        Object id2;
        EmiStack concreteWater = EmiStack.of((Fluid)Fluids.WATER);
        concreteWater.setRemainder(concreteWater);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.WHITE_CONCRETE_POWDER, concreteWater, Blocks.WHITE_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.ORANGE_CONCRETE_POWDER, concreteWater, Blocks.ORANGE_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.MAGENTA_CONCRETE_POWDER, concreteWater, Blocks.MAGENTA_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.LIGHT_BLUE_CONCRETE_POWDER, concreteWater, Blocks.LIGHT_BLUE_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.YELLOW_CONCRETE_POWDER, concreteWater, Blocks.YELLOW_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.LIME_CONCRETE_POWDER, concreteWater, Blocks.LIME_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.PINK_CONCRETE_POWDER, concreteWater, Blocks.PINK_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.GRAY_CONCRETE_POWDER, concreteWater, Blocks.GRAY_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.LIGHT_GRAY_CONCRETE_POWDER, concreteWater, Blocks.LIGHT_GRAY_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.CYAN_CONCRETE_POWDER, concreteWater, Blocks.CYAN_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.PURPLE_CONCRETE_POWDER, concreteWater, Blocks.PURPLE_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.BLUE_CONCRETE_POWDER, concreteWater, Blocks.BLUE_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.BROWN_CONCRETE_POWDER, concreteWater, Blocks.BROWN_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.GREEN_CONCRETE_POWDER, concreteWater, Blocks.GREEN_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.RED_CONCRETE_POWDER, concreteWater, Blocks.RED_CONCRETE);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.BLACK_CONCRETE_POWDER, concreteWater, Blocks.BLACK_CONCRETE);
        EmiIngredient axes = VanillaPlugin.damagedTool(VanillaPlugin.getPreferredTag(List.of("minecraft:axes", "c:axes", "c:tools/axes", "fabric:axes", "forge:tools/axes"), EmiStack.of((ItemLike)Items.IRON_AXE)), 1);
        for (Map.Entry<Block, Block> entry2 : AxeItemAccessor.getStrippedBlocks().entrySet()) {
            ResourceLocation id22 = VanillaPlugin.synthetic("world/stripping", EmiUtil.subId(entry2.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)entry2.getKey()), axes, EmiStack.of((ItemLike)entry2.getValue()), id22));
        }
        for (Map.Entry<Object, Object> entry3 : ((BiMap)WeatheringCopper.PREVIOUS_BY_BLOCK.get()).entrySet()) {
            id2 = VanillaPlugin.synthetic("world/stripping", EmiUtil.subId((Block)entry3.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.lambda$addWorldInteraction$46(entry3, axes, (ResourceLocation)id2));
        }
        for (Map.Entry<Object, Object> entry4 : ((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).entrySet()) {
            id2 = VanillaPlugin.synthetic("world/stripping", EmiUtil.subId((Block)entry4.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.lambda$addWorldInteraction$47(entry4, axes, (ResourceLocation)id2));
        }
        EmiIngredient shears = VanillaPlugin.damagedTool(EmiStack.of((ItemLike)Items.SHEARS), 1);
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/shearing", "minecraft/pumpkin")).leftInput(EmiStack.of((ItemLike)Items.PUMPKIN)).rightInput(shears, true).output(EmiStack.of((ItemLike)Items.PUMPKIN_SEEDS, 4L)).output(EmiStack.of((ItemLike)Items.CARVED_PUMPKIN)).build());
        EmiIngredient emiIngredient = VanillaPlugin.damagedTool(VanillaPlugin.getPreferredTag(List.of("minecraft:hoes", "c:hoes", "c:tools/hoes", "fabric:hoes", "forge:tools/hoes"), EmiStack.of((ItemLike)Items.IRON_HOE)), 1);
        for (Map.Entry entry5 : HoeItemAccessor.getTillingActions().entrySet()) {
            Consumer consumer = (Consumer)((Pair)entry5.getValue()).getSecond();
            if (!EmiClient.HOE_ACTIONS.containsKey(consumer)) continue;
            Block b = (Block)entry5.getKey();
            id = VanillaPlugin.synthetic("world/tilling", EmiUtil.subId(b));
            List<EmiStack> list = EmiClient.HOE_ACTIONS.get(consumer).stream().map(EmiStack::of).toList();
            if (list.size() == 1) {
                VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)b), hoes, (EmiStack)list.get(0), id));
                continue;
            }
            if (list.size() == 2) {
                VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(id).leftInput(EmiStack.of((ItemLike)b)).rightInput(hoes, true).output((EmiStack)list.get(0)).output((EmiStack)list.get(1)).build());
                continue;
            }
            EmiReloadLog.warn("Encountered hoe action of peculiar size " + list.size() + ", skipping.");
        }
        EmiIngredient shovels = VanillaPlugin.damagedTool(VanillaPlugin.getPreferredTag(List.of("minecraft:shovels", "c:shovels", "c:tools/shovels", "fabric:shovels", "forge:tools/shovels"), EmiStack.of((ItemLike)Items.IRON_SHOVEL)), 1);
        for (Map.Entry<Block, BlockState> entry6 : ShovelItemAccessor.getPathStates().entrySet()) {
            Block result = entry6.getValue().getBlock();
            id = VanillaPlugin.synthetic("world/flattening", EmiUtil.subId(entry6.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)entry4.getKey()), shovels, EmiStack.of((ItemLike)result), id));
        }
        EmiStack emiStack = EmiStack.of((ItemLike)Items.HONEYCOMB);
        for (Map.Entry entry5 : ((BiMap)HoneycombItem.WAXABLES.get()).entrySet()) {
            id = VanillaPlugin.synthetic("world/waxing", EmiUtil.subId((Block)entry5.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)entry5.getKey()), honeycomb, EmiStack.of((ItemLike)entry5.getValue()), id, false));
        }
        for (Item i : dyeableItems) {
            if (hiddenItems.contains(i)) continue;
            EmiStack cauldron = EmiStack.of((ItemLike)Items.CAULDRON);
            EmiStack waterThird = EmiStack.of((Fluid)Fluids.WATER, (long)FluidUnit.BOTTLE);
            int uniq = EmiUtil.RANDOM.nextInt();
            VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/cauldron_washing", EmiUtil.subId(i))).leftInput(EmiStack.EMPTY, s -> new GeneratedSlotWidget(r -> {
                ItemStack stack = i.getDefaultInstance();
                stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(r.nextInt(0x1000000), true));
                return EmiStack.of(stack);
            }, uniq, s.getBounds().x(), s.getBounds().y())).rightInput(cauldron, true).rightInput(waterThird, false).output(EmiStack.of((ItemLike)i)).supportsRecipeTree(false).build());
        }
        EmiStack emiStack2 = EmiStack.of((Fluid)Fluids.WATER, (long)FluidUnit.BUCKET);
        EmiStack lava = EmiStack.of((Fluid)Fluids.LAVA, (long)FluidUnit.BUCKET);
        EmiStack waterCatalyst = emiStack2.copy().setRemainder(emiStack2);
        EmiStack lavaCatalyst = lava.copy().setRemainder(lava);
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_spring", "minecraft/water")).leftInput(waterCatalyst).rightInput(waterCatalyst, false).output(EmiStack.of((Fluid)Fluids.WATER, (long)FluidUnit.BUCKET)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/cobblestone")).leftInput(waterCatalyst).rightInput(lavaCatalyst, false).output(EmiStack.of((ItemLike)Items.COBBLESTONE)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/stone")).leftInput(waterCatalyst).rightInput(lavaCatalyst, false).output(EmiStack.of((ItemLike)Items.STONE)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/obsidian")).leftInput(lava).rightInput(waterCatalyst, false).output(EmiStack.of((ItemLike)Items.OBSIDIAN)).build());
        EmiStack soulSoil = EmiStack.of((ItemLike)Items.SOUL_SOIL);
        soulSoil.setRemainder(soulSoil);
        EmiStack blueIce = EmiStack.of((ItemLike)Items.BLUE_ICE);
        blueIce.setRemainder(blueIce);
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/basalt")).leftInput(lavaCatalyst).rightInput(soulSoil, false, s -> s.appendTooltip((Component)EmiPort.translatable("tooltip.emi.fluid_interaction.basalt.soul_soil", ChatFormatting.GREEN))).rightInput(blueIce, false, s -> s.appendTooltip((Component)EmiPort.translatable("tooltip.emi.fluid_interaction.basalt.blue_ice", ChatFormatting.GREEN))).output(EmiStack.of((ItemLike)Items.BASALT)).build());
        EmiPort.getFluidRegistry().holders().forEach(entry -> {
            Fluid fluid = (Fluid)entry.value();
            Item bucket = fluid.getBucket();
            if (fluid.isSource(fluid.defaultFluidState()) && !fluid.defaultFluidState().createLegacyBlock().isAir() && bucket != Items.AIR && fluid instanceof FlowingFluid) {
                VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)Items.BUCKET), EmiStack.of(fluid, (long)FluidUnit.BUCKET), EmiStack.of((ItemLike)bucket), VanillaPlugin.synthetic("emi", "bucket_filling/" + EmiUtil.subId(fluid)), false));
            }
        });
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)Items.GLASS_BOTTLE), water, EmiStack.of(EmiPort.setPotion(new ItemStack((ItemLike)Items.POTION), (Potion)Potions.WATER.value())), VanillaPlugin.synthetic("world/unique", "minecraft/water_bottle")));
        EmiStack waterBottle = EmiStack.of(EmiPort.setPotion(new ItemStack((ItemLike)Items.POTION), (Potion)Potions.WATER.value())).setRemainder(EmiStack.of((ItemLike)Items.GLASS_BOTTLE));
        EmiStack mud = EmiStack.of((ItemLike)Items.MUD);
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)Items.DIRT), waterBottle, mud, VanillaPlugin.synthetic("world/unique", "minecraft/mud"), false));
    }

    private static EmiIngredient damagedTool(EmiIngredient tool, int damage) {
        for (EmiStack stack : tool.getEmiStacks()) {
            ItemStack is = stack.getItemStack().copy();
            is.setDamageValue(1);
            stack.setRemainder(EmiStack.of(is));
        }
        return tool;
    }

    private static EmiIngredient getPreferredTag(List<String> candidates, EmiIngredient fallback) {
        for (String id : candidates) {
            EmiIngredient potential = EmiIngredient.of(TagKey.create((ResourceKey)EmiPort.getItemRegistry().key(), (ResourceLocation)EmiPort.id(id)));
            if (potential.isEmpty()) continue;
            return potential;
        }
        return fallback;
    }

    private static void addFuel(EmiRegistry registry, Set<Item> hiddenItems) {
        Map<Item, Integer> fuelMap = EmiAgnos.getFuelMap();
        VanillaPlugin.compressRecipesToTags(fuelMap.keySet().stream().collect(Collectors.toSet()), (a, b) -> Integer.compare((Integer)fuelMap.get(a), (Integer)fuelMap.get(b)), tag -> {
            EmiIngredient stack = EmiIngredient.of(tag);
            Item item = stack.getEmiStacks().get(0).getItemStack().getItem();
            int time = (Integer)fuelMap.get(item);
            registry.addRecipe(new EmiFuelRecipe(stack, time, VanillaPlugin.synthetic("fuel/tag", EmiUtil.subId(tag.location()))));
        }, item -> {
            if (!hiddenItems.contains(item)) {
                int time = (Integer)fuelMap.get(item);
                registry.addRecipe(new EmiFuelRecipe(EmiStack.of((ItemLike)item), time, VanillaPlugin.synthetic("fuel/item", EmiUtil.subId(item))));
            }
        });
    }

    private static void addComposting(EmiRegistry registry, Set<Item> hiddenItems) {
        VanillaPlugin.compressRecipesToTags(ComposterBlock.COMPOSTABLES.keySet().stream().map(ItemLike::asItem).collect(Collectors.toSet()), (a, b) -> Float.compare(ComposterBlock.COMPOSTABLES.getFloat(a), ComposterBlock.COMPOSTABLES.getFloat(b)), tag -> {
            EmiIngredient stack = EmiIngredient.of(tag);
            Item item = stack.getEmiStacks().get(0).getItemStack().getItem();
            float chance = ComposterBlock.COMPOSTABLES.getFloat((Object)item);
            registry.addRecipe(new EmiCompostingRecipe(stack, chance, VanillaPlugin.synthetic("composting/tag", EmiUtil.subId(tag.location()))));
        }, item -> {
            if (!hiddenItems.contains(item)) {
                float chance = ComposterBlock.COMPOSTABLES.getFloat(item);
                registry.addRecipe(new EmiCompostingRecipe(EmiStack.of((ItemLike)item), chance, VanillaPlugin.synthetic("composting/item", EmiUtil.subId(item))));
            }
        });
    }

    private static void compressRecipesToTags(Set<Item> stacks, Comparator<Item> comparator, Consumer<TagKey<Item>> tagConsumer, Consumer<Item> itemConsumer) {
        HashSet handled = Sets.newHashSet();
        block0: for (TagKey<Item> key : EmiTags.getTags(EmiPort.getItemRegistry())) {
            Item base;
            List<Item> items = EmiUtil.values(key).map(Holder::value).toList();
            if (items.size() < 2 || !stacks.contains(base = items.get(0))) continue;
            for (int i = 1; i < items.size(); ++i) {
                Item item = items.get(i);
                if (!stacks.contains(item) || comparator.compare(base, item) != 0) continue block0;
            }
            if (handled.containsAll(items)) continue;
            handled.addAll(items);
            tagConsumer.accept(key);
        }
        for (Item item : stacks) {
            if (handled.contains(item)) continue;
            itemConsumer.accept(item);
        }
    }

    private static ResourceLocation synthetic(String type, String name) {
        return EmiPort.id("emi", "/" + type + "/" + name);
    }

    private static <C extends RecipeInput, T extends Recipe<C>> Iterable<T> getRecipes(EmiRegistry registry, RecipeType<T> type) {
        return registry.getRecipeManager().getAllRecipesFor(type).stream().map(e -> e.value())::iterator;
    }

    private static void safely(String name, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            EmiReloadLog.warn("Exception thrown when reloading " + name + " step in vanilla EMI plugin", t);
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn("Exception thrown when parsing EMI recipe (no ID available)", e);
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier, Recipe<?> recipe) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn("Exception thrown when parsing vanilla recipe " + String.valueOf(EmiPort.getId(recipe)), e);
        }
    }

    private static EmiRenderable simplifiedRenderer(int u, int v) {
        return (raw, x, y, delta) -> {
            EmiDrawContext context = EmiDrawContext.wrap(raw);
            context.drawTexture(EmiRenderHelper.WIDGETS, x, y, u, v, 16, 16);
        };
    }

    private static void addConcreteRecipe(EmiRegistry registry, Block powder, EmiStack water, Block result) {
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)powder), water, EmiStack.of((ItemLike)result), VanillaPlugin.synthetic("world/concrete", EmiUtil.subId(result))));
    }

    private static EmiRecipe basicWorld(EmiIngredient left, EmiIngredient right, EmiStack output, ResourceLocation id) {
        return VanillaPlugin.basicWorld(left, right, output, id, true);
    }

    private static EmiRecipe basicWorld(EmiIngredient left, EmiIngredient right, EmiStack output, ResourceLocation id, boolean catalyst) {
        return EmiWorldInteractionRecipe.builder().id(id).leftInput(left).rightInput(right, catalyst).output(output).build();
    }

    private static /* synthetic */ EmiRecipe lambda$addWorldInteraction$47(Map.Entry entry, EmiIngredient axes, ResourceLocation id) {
        return VanillaPlugin.basicWorld(EmiStack.of((ItemLike)entry.getKey()), axes, EmiStack.of((ItemLike)entry.getValue()), id);
    }

    private static /* synthetic */ EmiRecipe lambda$addWorldInteraction$46(Map.Entry entry, EmiIngredient axes, ResourceLocation id) {
        return VanillaPlugin.basicWorld(EmiStack.of((ItemLike)entry.getKey()), axes, EmiStack.of((ItemLike)entry.getValue()), id);
    }

    static {
        VanillaEmiRecipeCategories.CRAFTING = new EmiRecipeCategory(EmiPort.id("minecraft:crafting"), EmiStack.of((ItemLike)Items.CRAFTING_TABLE), VanillaPlugin.simplifiedRenderer(240, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.SMELTING = new EmiRecipeCategory(EmiPort.id("minecraft:smelting"), EmiStack.of((ItemLike)Items.FURNACE), VanillaPlugin.simplifiedRenderer(224, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.BLASTING = new EmiRecipeCategory(EmiPort.id("minecraft:blasting"), EmiStack.of((ItemLike)Items.BLAST_FURNACE), VanillaPlugin.simplifiedRenderer(208, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.SMOKING = new EmiRecipeCategory(EmiPort.id("minecraft:smoking"), EmiStack.of((ItemLike)Items.SMOKER), VanillaPlugin.simplifiedRenderer(192, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.CAMPFIRE_COOKING = new EmiRecipeCategory(EmiPort.id("minecraft:campfire_cooking"), EmiStack.of((ItemLike)Items.CAMPFIRE), VanillaPlugin.simplifiedRenderer(176, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.STONECUTTING = new EmiRecipeCategory(EmiPort.id("minecraft:stonecutting"), EmiStack.of((ItemLike)Items.STONECUTTER), VanillaPlugin.simplifiedRenderer(160, 240), EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.SMITHING = new EmiRecipeCategory(EmiPort.id("minecraft:smithing"), EmiStack.of((ItemLike)Items.SMITHING_TABLE), VanillaPlugin.simplifiedRenderer(240, 224), EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.ANVIL_REPAIRING = new EmiRecipeCategory(EmiPort.id("emi:anvil_repairing"), EmiStack.of((ItemLike)Items.ANVIL), VanillaPlugin.simplifiedRenderer(240, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.GRINDING = new EmiRecipeCategory(EmiPort.id("emi:grinding"), EmiStack.of((ItemLike)Items.GRINDSTONE), VanillaPlugin.simplifiedRenderer(192, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.BREWING = new EmiRecipeCategory(EmiPort.id("minecraft:brewing"), EmiStack.of((ItemLike)Items.BREWING_STAND), VanillaPlugin.simplifiedRenderer(224, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.WORLD_INTERACTION = new EmiRecipeCategory(EmiPort.id("emi:world_interaction"), EmiStack.of((ItemLike)Items.GRASS_BLOCK), VanillaPlugin.simplifiedRenderer(208, 224), EmiRecipeSorting.none());
        EmiRenderable flame = (matrices, x, y, delta) -> EmiTexture.FULL_FLAME.render(matrices, x + 1, y + 1, delta);
        VanillaEmiRecipeCategories.FUEL = new EmiRecipeCategory(EmiPort.id("emi:fuel"), flame, flame, EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.COMPOSTING = new EmiRecipeCategory(EmiPort.id("emi:composting"), EmiStack.of((ItemLike)Items.COMPOSTER), EmiStack.of((ItemLike)Items.COMPOSTER), EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.INFO = new EmiRecipeCategory(EmiPort.id("emi:info"), EmiStack.of((ItemLike)Items.WRITABLE_BOOK), VanillaPlugin.simplifiedRenderer(208, 224), EmiRecipeSorting.none());
    }
}

